<?php

namespace App\Controllers\admin;

use App\Controllers\Auth;

class Users extends Admin
{
    public $user_model, $admin_id;
    public function __construct()
    {
        parent::__construct();
        $this->user_model = new \App\Models\Users_model();
        $this->ionAuth = new \IonAuth\Libraries\IonAuth();
        $this->admin_id = ($this->ionAuth->isAdmin()) ? $this->ionAuth->user()->row()->id : 0;
        $this->superadmin = $this->session->get('email');
    }

    public function index()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            $this->data['title'] = 'User List | Admin Panel';
            $this->data['main_page'] = 'users';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }

    public function tts()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            $this->data['title'] = 'Users TTS - Admin Panel | eDemand';
            $this->data['main_page'] = 'users_tts';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }
    public function list_user()
    {
        $limit = (isset($_GET['limit']) && !empty($_GET['limit'])) ? $_GET['limit'] : 10;
        $offset = (isset($_GET['offset']) && !empty($_GET['offset'])) ? $_GET['offset'] : 0;
        $sort = (isset($_GET['sort']) && !empty($_GET['sort'])) ? $_GET['sort'] : 'id';
        $order = (isset($_GET['order']) && !empty($_GET['order'])) ? $_GET['order'] : 'ASC';
        $search = (isset($_GET['search']) && !empty($_GET['search'])) ? $_GET['search'] : '';

        $data = json_encode($this->user_model->list(false, $search, $limit, $offset, $sort, $order));
        
        return $data;
    }
    public function deactivate()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
              
       
            $id = $this->request->getVar('user_id');

            $operations = $this->ionAuth->deactivate($id);
            if ($operations) {

                $response = [
                    'error' => false,
                    'message' => "Email sended to the user successfully and user disabled",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            } else {
                $response = [
                    'error' => true,
                    'message' => "Could not deactivate User",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        } else {
            return redirect('admin/login');
        }
    }

    public function activate()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            
                   $id = $this->request->getVar('user_id');



            $operations =   $this->ionAuth->activate($id);
            if ($operations) {

                $response = [
                    'error' => false,
                    'message' => "Email sended to the user successfully and user have been disabled",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            } else {
                $response = [
                    'error' => true,
                    'message' => "Eroor may have occured",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        } else {
            return redirect('admin/login');
        }
    }
}
